CONTAINER fx_fluid
{
	NAME fx_fluid;
	INCLUDE fx_force_base;
	INCLUDE fx_base_display;

	GROUP FX_BASE_QUICKTAB
	{		
		COLUMNS 4;
		BUTTON FLUID_QUICK_VARIABLEDENSITY {}
		BUTTON FLUID_QUICK_VARIABLEVISCOSITY {HIDDEN;}
		BUTTON FLUID_QUICK_PARTICLETURBULENCE {}
	}

	GROUP ID_FORCE_BASE
	{		
		GROUP ID_PORT_BASE
		{
			COLUMNS 2;
			LINK FLUID_DENSITY_CHANNEL { ACCEPT {fx_channel_scalar; fx_group;} }	
			BUTTON FLUID_DENSITY_CHANNEL_SELECTOR {}

			LINK LIQUID_VISCOSITY_CHANNEL { ACCEPT {fx_channel_scalar; fx_channel_temp; fx_channel_fuel; fx_channel_fire; fx_group;} }
			BUTTON LIQUID_VISCOSITY_CHANNEL_SELECTOR {}

			IN_EXCLUDE FLUID_FORCES_GRID
			{
				SCALE_H; SCALE_V;
				NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 0;
				ACCEPT {  fx_force_curl; fx_force_plugin; fx_force_base; fx_force_vortex; fx_force_trigowave; fx_force_coffee; fx_force_gravity; fx_force_swirling; fx_force_particleturbulence; fx_force_buoyancy;}
			}
			BUTTON FLUID_FORCES_GRID_SELECTOR {SCALE_V; FIT_H;}

			LINK	FLUID_DURATION {ACCEPT{fx_duration; fx_group;}}
			BUTTON	FLUID_DURATION_SELECTOR {SCALE_V; FIT_H;}
		}
		LONG FLUID_CONTAINER_ADAPTIVE {MIN 0; MAX 200;}
		VECTOR FLUID_CONTAINER_DIMENSIONS {MIN 0.001 0.001 0.001; UNIT METER;}
		
		LONG FLUID_CONTAINER_CENTER
		{
			CYCLE
			{
			FLUID_CONTAINER_CENTER_MIN;
			FLUID_CONTAINER_CENTER_MID;
			FLUID_CONTAINER_CENTER_MIDMINY;
			FLUID_CONTAINER_CENTER_CUSTOM;
			}
		}
		VECTOR FLUID_CONTAINER_CENTER_POS {UNIT PERCENT;}

		
		GROUP 
		{	
			DEFAULT 1;COLUMNS 6;

			LONG FLUID_CONTAINER_OBSTACLES_BRD_LEFT	{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 1; BNAME BNAME_LEFT;BLENGTH 55; ANIM OFF;}
			LONG FLUID_CONTAINER_OBSTACLES_BRD_RIGHT	{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 2; BNAME BNAME_RIGHT;BLENGTH 55;  ANIM OFF;}
			LONG FLUID_CONTAINER_OBSTACLES_BRD_BOTTOM	{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 3; BNAME BNAME_BOTTOM;BLENGTH 55;  ANIM OFF;}
			LONG FLUID_CONTAINER_OBSTACLES_BRD_TOP		{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 4; BNAME BNAME_TOP;BLENGTH 55;  ANIM OFF;}
			LONG FLUID_CONTAINER_OBSTACLES_BRD_FRONT	{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 5; BNAME BNAME_FRONT;BLENGTH 55;  ANIM OFF;}
			LONG FLUID_CONTAINER_OBSTACLES_BRD_BACK	{MIN 0; MAX 1; CUSTOMGUI VISIBILITY; BOOLEAN; ISBIT; BITS 6; BNAME BNAME_BACK;BLENGTH 55;  ANIM OFF;}			
		}	
		
		SEPARATOR {LINE;}
		GROUP FLUID_GROUP_MATERIAL
		{
			COLUMNS 2;DEFAULT 1;
			LONG FLUID_VISCOSITY_PRESETS
			{
				CYCLE
				{
					FLUID_VISCOSITY_PRESETS_CUSTOM;
					FLUID_VISCOSITY_PRESETS_WATER_DISTILLED;
					FLUID_VISCOSITY_PRESETS_WATER_FRESH;
					FLUID_VISCOSITY_PRESETS_WATER_SEA;
					FLUID_VISCOSITY_PRESETS_TURPENTINE;
					FLUID_VISCOSITY_PRESETS_RAPESEEDOIL;
					FLUID_VISCOSITY_PRESETS_OLIVEOIL;
					FLUID_VISCOSITY_PRESETS_MILK;
					FLUID_VISCOSITY_PRESETS_MERCURY;
					FLUID_VISCOSITY_PRESETS_KEROSENE;
					FLUID_VISCOSITY_PRESETS_INK;
					FLUID_VISCOSITY_PRESETS_HONEY;
					FLUID_VISCOSITY_PRESETS_GASOLINE;
					FLUID_VISCOSITY_PRESETS_FUELOIL;
					FLUID_VISCOSITY_PRESETS_GEAROIL;
					FLUID_VISCOSITY_PRESETS_DIESELFUEL2D;
					FLUID_VISCOSITY_PRESETS_BEER;
					FLUID_VISCOSITY_PRESETS_ASPHALT;
					FLUID_VISCOSITY_PRESETS_BLOOD;
					FLUID_VISCOSITY_PRESETS_PEANUTBUTTER;
					FLUID_VISCOSITY_PRESETS_KETCHUP;
					FLUID_VISCOSITY_PRESETS_MOLTENCHOCOLATE;
				}
			} 
			REAL FLUID_VISCOSITY { MIN 0.0;  MAX 1000000.0; STEP 0.000001; CUSTOMGUI DOUBLE; DSIZE 70; DDIGITS 8; }
			LONG FLUID_DENSITY_PRESETS
			{
				CYCLE
				{
					FLUID_DENSITY_PRESETS_CUSTOM;
					FLUID_DENSITY_PRESETS_WATER;
					FLUID_DENSITY_PRESETS_WATER_SALINE;
					FLUID_DENSITY_PRESETS_WATER_SEA;
					FLUID_DENSITY_PRESETS_TURPENTINE;
					FLUID_DENSITY_PRESETS_RAPESEEDOIL;
					FLUID_DENSITY_PRESETS_OLIVEOIL;
					FLUID_DENSITY_PRESETS_MILK;
					FLUID_DENSITY_PRESETS_MOLASSES;
					FLUID_DENSITY_PRESETS_MERCURY;
					FLUID_DENSITY_PRESETS_KEROSENE;
					FLUID_DENSITY_PRESETS_INK;
					FLUID_DENSITY_PRESETS_HONEY;
					FLUID_DENSITY_PRESETS_GASOLINE;
					FLUID_DENSITY_PRESETS_FUELOIL;
					FLUID_DENSITY_PRESETS_GEAROIL;
					FLUID_DENSITY_PRESETS_DIESELFUEL2D;
					FLUID_DENSITY_PRESETS_BEER;
					FLUID_DENSITY_PRESETS_ASPHALT;
					FLUID_DENSITY_PRESETS_BLOOD;
					FLUID_DENSITY_PRESETS_PEANUTBUTTER;
					FLUID_DENSITY_PRESETS_KETCHUP;
					FLUID_DENSITY_PRESETS_MOLTENCHOCOLATE;
				}
			}
			REAL FLUID_DENSITY   { MIN 0.01; MAX 100000; STEP 0.1; CUSTOMGUI DOUBLE; DSIZE 70; DDIGITS 2;}
		}
		GROUP FLUID_GROUP_DYNAMICS
		{	
			DEFAULT 1;
			BOOL FLUID_COMPATIBILITY {}	
			BOOL FLUID_CONVECT {}	
			LONG FLUID_CONTAINER_EXTRAPOLATION_LAYERS {MIN 0; MAX 10;}	

			SEPARATOR FLUID_GROUP_CONTAINER_OBSTACLES {}
			
			BOOL FLUID_CONTAINER_OBSTACLES_POLYNORMALS {}
			BOOL FLUID_CONTAINER_VELCONSTRAINT_DIRICHLET {}
			REAL FLUID_CONTAINER_VELCONSTRAINT_SLIP {MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }	
		}
		GROUP SOLVER_GROUP_ID
		{			
			LONG SOLVER_SOLVERTYPE
			{
				CYCLE
				{
					SOLVER_SOLVERTYPE_CG;
					SOLVER_SOLVERTYPE_GAUSS;
				}
			}
			LONG SOLVER_MPEDITOR {MIN 0; HIDDEN;}
			LONG SOLVER_MPRENDER {MIN 0; HIDDEN;}

			LONG SOLVER_MAXITERATIONS { MIN 5; MAX 1000; STEP 5; CUSTOMGUI LONGSLIDER;}
			REAL SOLVER_ACCURACY { MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }

			SEPARATOR {}
			
			LONG SOLVER_MAXITERATIONS_VISCOSITY { MIN 5; MAX 1000; STEP 5; CUSTOMGUI LONGSLIDER;}
			REAL SOLVER_ACCURACY_VISCOSITY { MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }
			GROUP SOLVER_SUB_ADVANCED
			{
				DEFAULT 0;
				REAL SOLVER_PCG_MINDIAGONAL	{ MIN 0.0; MAX 1.0; STEP 0.001;}
				REAL SOLVER_PCG_FACTOR		{ MIN 0.0; MAX 1.0; STEP 0.01;}
			}		
		}
	}
	GROUP FX_BASE_DISPLAYTAB
	{
		BOOL FLUID_DISPLAY_SHOWBOUNDS {}
		STRING FLUID_CONTAINER_INFO 
		{
			SCALE_V; SCALE_H; CUSTOMGUI MULTISTRING; READONLY; ANIM OFF;
		}

		SEPARATOR {LINE;}

		LONG FLUID_DISPLAY_VELOCITY 
		{
			CYCLE {
			FLUID_DISPLAY_VELOCITY_OFF;
			FLUID_DISPLAY_VELOCITY_ON;
			FLUID_DISPLAY_VELOCITY_Y;
			FLUID_DISPLAY_VELOCITY_Z;
			}
		}
		REAL FLUID_DISPLAY_VELOCITY_MIX { MIN 0; MAX 100; UNIT PERCENT; CUSTOMGUI REALSLIDER; }
		BOOL FLUID_DISPLAY_VELOCITY_DOTONLY {}
		REAL FLUID_DISPLAY_VELOCITY_CUTOFF { MIN 0; MAX 1; STEP 0.01;}
		REAL FLUID_DISPLAY_VELOCITY_MAX { MIN 1; MAX 10000; STEP 0.5;}
		COLOR FLUID_DISPLAY_VELOCITY_COLOR {}
		BOOL FLUID_DISPLAY_VELOCITY_AUTOTRANSPARENCY {}

		SEPARATOR {LINE;}

		LONG FLUID_DISPLAY_BOUNDARY 
		{
			CYCLE {FLUID_DISPLAY_BOUNDARY_OFF;FLUID_DISPLAY_BOUNDARY_ON;}			
		}
		LONG FLUID_DISPLAY_GRID
		{
			CYCLE {FLUID_DISPLAY_GRID_OFF;FLUID_DISPLAY_GRID_ON;}	
		}
	}
}